#ifndef cshieldLib_h__
#define cshieldLib_h__

#include <memory>
#include <cstring>

#ifndef _WIN32
typedef unsigned int DWORD;
typedef unsigned char BYTE;
#endif

class CShield
{
public:
	CShield();

	// Movespeed
private:
	DWORD m_mshNextReduction;
	bool isRidingLocal;
	int m_mshHackCount;
	long m_mshStartX;
	long m_mshStartY;
	DWORD m_mshStartDetect;
	DWORD m_mshLastDetect;
	DWORD m_mshIgnoreUntil;
	DWORD m_mshFirstDetect;
public:
	bool CheckMoveSpeedhack(long x, long y, DWORD time, bool isRiding, float moveSpeed);
	void ResetMoveSpeedhack(DWORD time) { m_mshIgnoreUntil = time + 1 * 1000; m_mshStartDetect = 0; }

	// Waithack
private:
	DWORD m_dwCountWaithackPoint;
	long m_mshStartX2;
	long m_mshStartY2;
	DWORD m_mshStartDetect2;
	DWORD startDetect;
	int distWalked;
	int mobCount;
public:
	bool CheckWaithack(long x, long y, DWORD time, float moveSpeed);

	// Attackspeed Hack
private:
	// boss
	DWORD m_dwCountAttackSpeedhackPoint_1;
	DWORD dwAttackVID_1;
	DWORD dwAttackTime_1;
	// monster
	DWORD m_dwCountAttackSpeedhackPoint_2;
	DWORD dwAttackVID_2;
	DWORD dwAttackTime_2;
	// stone
	DWORD m_dwCountAttackSpeedhackPoint_3;
	DWORD dwAttackVID_3;
	DWORD dwAttackTime_3;
	// player
	DWORD m_dwCountAttackSpeedhackPoint_4;
	DWORD dwAttackVID_4;
	DWORD dwAttackTime_4;
	// boss extended
	DWORD m_dwCountAttackSpeedhackPoint_1_extended;
	DWORD dwAttackVID_1_extended;
	DWORD dwAttackTime_1_extended;
	// monster extended
	DWORD m_dwCountAttackSpeedhackPoint_2_extended;
	DWORD dwAttackVID_2_extended;
	DWORD dwAttackTime_2_extended;
	// stone extended
	DWORD m_dwCountAttackSpeedhackPoint_3_extended;
	DWORD dwAttackVID_3_extended;
	DWORD dwAttackTime_3_extended;
	// player extended
	DWORD m_dwCountAttackSpeedhackPoint_4_extended;
	DWORD dwAttackVID_4_extended;
	DWORD dwAttackTime_4_extended;
public:
	DWORD CheckAttackspeedHack(bool isRiding, bool isFastWeapon, bool isTwoHanded, DWORD ani_speed, int att_speed, DWORD victimVID, DWORD time, DWORD victimType, bool extendedCheck);

	// AttackspeedBow Hack
private:
	DWORD m_dwCountAttackSpeedhackBowPoint;
	DWORD dwAttackBowTime;
	// extended
	DWORD m_dwCountAttackSpeedhackBowPoint_extended;
	DWORD dwAttackBowTime_extended;
public:
	DWORD CheckAttackspeedBowHack(DWORD ani_speed, int att_speed, DWORD time, bool extendedCheck);

	// Verification
private:
	time_t cShieldTime;
	DWORD cShieldTriesCount;
	DWORD cShieldNumber;
	bool cShieldInit;
	char keyStored[128] = { 0 };
	char keyLocalStored[128] = { 0 };
	char keyLocalStored2[128] = { 0 };
public:
	DWORD VerifyCShield(const char* playerName);
	bool GetCShieldInit() { return cShieldInit; }
	void SetCShieldIinit() { cShieldInit = true; }
	char* GetKeyLocalStored() { return keyLocalStored; }
	void SetKeyLocalStored(const char* key) { strncpy(keyLocalStored, key, sizeof(keyLocalStored)); }
	char* GetKeyLocalStored2() { return keyLocalStored2; }
	void SetKeyLocalStored2(const char* key) { strncpy(keyLocalStored2, key, sizeof(keyLocalStored2)); }
	void SetCShieldNumber(DWORD num) { cShieldNumber = num; }
	DWORD GetCShieldNumber() { return cShieldNumber; }
	time_t GetCShieldTime() { return cShieldTime; }
	void SetCShieldTime() { cShieldTime = time(0); }
	void ResetCShieldTriesCount() { cShieldTriesCount = 0; }
	void IncreaseCShieldTriesCount() { cShieldTriesCount += 1; }
	DWORD GetCShieldTriesCount() { return cShieldTriesCount; }
	char* GetKeyStored() { return keyStored; }
	void SetKeyStored(const char* key) { strncpy(keyStored, key, sizeof(keyStored)); }

	// Logging
private:
	DWORD m_dwMetinCount;
	DWORD m_dwBossCount;
public:
	DWORD GetMetinCount() const { return m_dwMetinCount; }
	void SetMetinCount(DWORD metinCount) { m_dwMetinCount = metinCount; }
	DWORD GetBossCount() const { return m_dwBossCount; }
	void SetBossCount(DWORD bossCount) { m_dwBossCount = bossCount; }

	// Captcha
private:
	DWORD dwLastCaptchaPulse;
	short m_captchaResult;
	BYTE m_dwCaptchaCount;
	BYTE m_dwCaptchaSessionCount;
	BYTE m_dwCaptchaUnsolvedCount;
	time_t m_dwCaptchaTime;
	DWORD m_dwCaptchaAfterLoginTime;
public:
	std::string GenerateCaptcha(const short number);
	DWORD GetLastCaptchaPulse() const { return dwLastCaptchaPulse; }
	void SetLastCaptchaPulse(DWORD pulse) { dwLastCaptchaPulse = pulse; }
	short GetCaptchaResult() const { return m_captchaResult; }
	void SetCaptchaResult(short captchaResult) { m_captchaResult = captchaResult; }
	BYTE GetCaptchaCount() const { return m_dwCaptchaCount; }
	void SetCaptchaCount(BYTE captchaCount) { m_dwCaptchaCount = captchaCount; }
	BYTE GetCaptchaSessionCount() const { return m_dwCaptchaSessionCount; }
	void SetCaptchaSessionCount(BYTE captchaSessionCount) { m_dwCaptchaSessionCount = captchaSessionCount; }
	BYTE GetCaptchaUnsolvedCount() const { return m_dwCaptchaUnsolvedCount; }
	void SetCaptchaUnsolvedCount(BYTE captchaUnsolvedCount) { m_dwCaptchaUnsolvedCount = captchaUnsolvedCount; }
	time_t GetCaptchaTime() const { return m_dwCaptchaTime; }
	void SetCaptchaTime(time_t captchaTime) { m_dwCaptchaTime = captchaTime; }
	DWORD GetCaptchaAfterLoginTime() const { return m_dwCaptchaAfterLoginTime; }
	void SetCaptchaAfterLoginTime(DWORD captchaAfterLoginTime) { m_dwCaptchaAfterLoginTime = captchaAfterLoginTime; }
};

typedef std::shared_ptr<CShield> spCShield;

extern void InitCShield(const std::string verificationKey);
extern void UpdateCShield(const std::string verificationKey);
extern void UpdateCaptcha(const std::string verificationKey);
extern std::vector<std::string> GetPlayerWhitelist();
extern std::string BuildCShieldResponse(const char* clientVersion, const char* clientBinary_name, const char* clientBinary_hash);
extern std::string MapErrorCode(const DWORD errorcode);
extern std::string GetCShieldLoginKey(const char* name);
extern std::string GenerateCaptcha(const int number);
#ifndef _WIN32
extern void WhitelistIP(const char* ip);
#endif

#endif